﻿using System;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace mp3SplitHelper
{
    public partial class FrmSplitHelper : Form
    {
        public FrmSplitHelper()
        {
            InitializeComponent();
        }

        private void btnGo_Click(object sender, EventArgs e)
        {
            
            FolderBrowserDialog fbd = new FolderBrowserDialog() { Description = "Select folder to process all files in" };
            if (string.IsNullOrEmpty(txtPath.Text))
            {
                fbd.ShowDialog();
                txtPath.Text = fbd.SelectedPath;
                Properties.Settings.Default["Path"] = fbd.SelectedPath;
            }

            var selectedPath = Properties.Settings.Default["Path"] as string;
            var results = new StringBuilder();
            if (!string.IsNullOrEmpty(selectedPath))
            {
                //selectedPath = @"F:\120gb\Quranicaudio\[Quran] Ahmed ibn Ali al-Ajmy [160Kbps]";
                string[] files = Directory.GetFiles(selectedPath);
                foreach (var file in files) {
                    if (!file.EndsWith(".txt"))
                        continue;
                    var fileName = new FileInfo(file).Name;
                    var fileNameNoExt = fileName.Substring(0, fileName.LastIndexOf("."));
                    
                    var args = string.Format("{0} {1} {2}", @"-jar c:\utils\split\VBVSplitMp3s.jar" ,fileNameNoExt + ".mp3", fileNameNoExt + ".txt");
                    var processStartInfo = new ProcessStartInfo(@"java",args);
                    processStartInfo.WorkingDirectory = selectedPath;
                    //processStartInfo.RedirectStandardOutput = true;
                    //processStartInfo.RedirectStandardError = true;
                    //processStartInfo.UseShellExecute = false;
                    processStartInfo.WindowStyle = ProcessWindowStyle.Normal;
                    var proc = Process.Start(processStartInfo);
                    
                    //string t = proc.StandardError.ReadToEnd();
                    proc.WaitForExit();
                    results.AppendLine(fileName);
                }
            }
            txtResults.Text = results.ToString();
        }

        private void FrmSplitHelper_Load(object sender, EventArgs e)
        {

            if (!string.IsNullOrEmpty(Properties.Settings.Default["Path"] as string))
            {
                txtPath.Text = Properties.Settings.Default["Path"] as string;
            }
            
        }

        private void FrmSplitHelper_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default["Path"] = txtPath.Text;
            Properties.Settings.Default.Save();
        }
    }
}
